/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.stream;

import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsEvent;
import com.ibm.hwmca.fw.fcs.FcsEventListener;
import com.ibm.hwmca.fw.fcs.FcsException;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletClient;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletClientManager;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletClientPortal;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletException;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletMessage;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletRequest;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletResponse;
import com.ibm.hwmca.fw.fcs.impl.FcsConnectionManager;
import com.ibm.hwmca.fw.fcs.impl.stream.StreamConstants;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FcsControlClient
implements Runnable,
StreamConstants,
ChatletClient {
    private static final String TRACE_MASKD = "XFCSFCCD";
    private static final String TRACE_MASKF = "XFCSFCCF";
    private static final String TRACE_MASKT = "XFCSFCCT";
    private ChatletClientPortal portal;
    private static Map chatletClients = new HashMap();
    private static Object chatletLock = new Object();
    private MachineId machineId;
    private InetAddress iaddr;
    private String operation;
    private static Object openConnectionsLock = new Object();
    private static Object badConnectionsLock = new Object();
    private static List openConnections = new ArrayList();
    private static Map badConnections = new HashMap();
    private static Map retryMap = new HashMap();
    private static final int MAX_RETRIES = 3;
    private static final int MAX_BLACKLIST = 12;

    public FcsControlClient(InetAddress iaddr, String operation) {
        this.machineId = FcsServer.getFcsServer().getMachineId(iaddr);
        if (this.machineId == null) {
            this.iaddr = iaddr;
            MachineId localId = FcsServer.getFcsServer().getLocalMachineId();
            this.machineId = new MachineId(iaddr.getHostName(), localId.getGroup(), localId.getVersion(), localId.getType(), localId.getFcsVersion(), new InetAddress[]{iaddr}, new boolean[]{true});
        }
        this.operation = operation;
    }

    public FcsControlClient(MachineId machineId, String operation) {
        this.machineId = machineId;
        this.operation = operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validConnection() {
        int i;
        MachineId localMachine = FcsServer.getFcsServer().getLocalMachineId();
        for (int i2 = 0; i2 < this.machineId.getNicAddresses().length; ++i2) {
            for (int j = 0; j < localMachine.getNicAddresses().length; ++j) {
                if (this.machineId.getNicAddresses()[i2] == null || localMachine.getNicAddresses()[j] == null) continue;
                if (this.machineId.getNicAddresses()[i2].equals(localMachine.getNicAddresses()[j])) {
                    return false;
                }
                if (!this.machineId.getNicAddresses()[i2].getHostAddress().startsWith("127.")) continue;
                return false;
            }
        }
        if (FcsServer.getFcsServer().isBlackListed(this.machineId)) {
            return false;
        }
        Object object = badConnectionsLock;
        synchronized (object) {
            for (i = 0; i < this.machineId.getNicAddresses().length; ++i) {
                if (this.machineId.getNicAddresses()[i] == null || !badConnections.containsKey(this.machineId.getNicAddresses()[i])) continue;
                return false;
            }
        }
        object = openConnectionsLock;
        synchronized (object) {
            for (i = 0; i < this.machineId.getNicAddresses().length; ++i) {
                if (this.machineId.getNicAddresses()[i] == null || !openConnections.contains(this.machineId.getNicAddresses()[i])) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean doConnect = true;
        MachineId localMachine = FcsServer.getFcsServer().getLocalMachineId();
        if (this.validConnection()) {
            for (int i = 0; i < this.machineId.getNicAddresses().length; ++i) {
                if (this.machineId.getNicAddresses()[i] == null) continue;
                openConnections.add(this.machineId.getNicAddresses()[i]);
            }
            FcsServiceId chatletServiceId = new FcsServiceId("com.ibm.hwmca.fw.fcs.impl.stream.FcsControlChatletServiceToken", 1.0);
            this.communicateViaChatlets();
            Object object = openConnectionsLock;
            synchronized (object) {
                for (int i = 0; i < this.machineId.getNicAddresses().length; ++i) {
                    if (this.machineId.getNicAddresses()[i] == null) continue;
                    openConnections.remove(this.machineId.getNicAddresses()[i]);
                }
            }
        } else if (!this.machineId.equals(FcsServer.getFcsServer().getLocalMachineId())) {
            Trace.trace(TRACE_MASKF, "Opting not to connect to " + this.machineId.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void communicateViaSockets() {
        block22: {
            FcsConnection connection = null;
            FcsServiceId serviceId = new FcsServiceId("com.ibm.hwmca.fw.fcs.impl.stream.FcsControlServiceToken", 1.0);
            Trace.trace(TRACE_MASKF, "connecting to: " + this.machineId.getNicAddresses()[0]);
            connection = FcsConnection.connect(this.machineId, serviceId);
            connection.getSocket().setSoTimeout(120000);
            Map outMap = this.buildOutMap();
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(connection.getSocket().getOutputStream()));
            oos.flush();
            oos.writeObject(outMap);
            oos.flush();
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(connection.getSocket().getInputStream()));
            Map inMap = (Map)ois.readObject();
            retryMap.remove(this.machineId);
            this.handleInMap(inMap);
            Object var8_11 = null;
            try {
                if (connection != null && connection.getSocket() != null) {
                    connection.getSocket().close();
                }
                break block22;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Closed socket, received expected exception: " + e.getMessage());
            }
            break block22;
            {
                catch (FcsException fcse) {
                    this.handleError(fcse);
                    if (this.iaddr == null) {
                        FcsServer.getFcsServer().removeRemoteServiceList(this.machineId);
                    } else {
                        FcsConnectionManager.removeConnectionInformation(this.iaddr);
                    }
                    Object var8_12 = null;
                    try {
                        if (connection != null && connection.getSocket() != null) {
                            connection.getSocket().close();
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Closed socket, received expected exception: " + e.getMessage());
                    }
                    break block22;
                }
                catch (IOException ioe) {
                    this.handleError(ioe);
                    Object var8_13 = null;
                    try {
                        if (connection != null && connection.getSocket() != null) {
                            connection.getSocket().close();
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Closed socket, received expected exception: " + e.getMessage());
                    }
                    break block22;
                }
                catch (ClassNotFoundException cnfe) {
                    this.handleError(cnfe);
                    Object var8_14 = null;
                    try {
                        if (connection != null && connection.getSocket() != null) {
                            connection.getSocket().close();
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Closed socket, received expected exception: " + e.getMessage());
                    }
                    break block22;
                }
                catch (RuntimeException runtimeException) {
                    Object var8_15 = null;
                    try {
                        if (connection != null && connection.getSocket() != null) {
                            connection.getSocket().close();
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Closed socket, received expected exception: " + e.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_16 = null;
                try {
                    if (connection != null && connection.getSocket() != null) {
                        connection.getSocket().close();
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Closed socket, received expected exception: " + e.getMessage());
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void communicateViaChatlets() {
        try {
            Object object = chatletLock;
            synchronized (object) {
                FcsControlClient chatletClient = (FcsControlClient)chatletClients.get(this.machineId);
                if (chatletClient == null) {
                    ChatletClientManager ccm = ChatletClientManager.getChatletClientManager(this.machineId);
                    ccm.registerChatlet(this);
                    chatletClients.put(this.machineId, this);
                }
            }
            if (this.portal == null) {
                throw new ChatletException("portal was null");
            }
            ChatletRequest request = new ChatletRequest();
            Map outMap = this.buildOutMap();
            request.setProperty("com.ibm.hwmca.fw.fcs.impl.stream.FcsControlChatletServiceToken", this.mapToBytes(outMap));
            ChatletResponse response = this.portal.sendRequest(request, 120000);
            Map inMap = this.bytesToMap((byte[])response.getProperty("com.ibm.hwmca.fw.fcs.impl.stream.FcsControlChatletServiceToken"));
            retryMap.remove(this.machineId);
            this.handleInMap(inMap);
        }
        catch (ChatletException ce) {
            Trace.trace(TRACE_MASKF, "error in communicateViaChatlets(), trying sockets now");
            this.communicateViaSockets();
        }
    }

    private byte[] mapToBytes(Map map) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(map);
            oos.flush();
            return baos.toByteArray();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception in mapToBytes()");
            return new byte[0];
        }
    }

    private Map bytesToMap(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object o = ois.readObject();
            return (Map)o;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception in bytesToMap()");
            return new HashMap();
        }
    }

    private Map buildOutMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FcsControlCommand", this.operation);
        if (this.operation.equals("FcsControlCommandDataExchange")) {
            map.put("FcsControlMachineId", FcsServer.getFcsServer().getLocalMachineId());
            map.put("FcsControlServices", FcsServer.getFcsServer().getLocalServices());
            map.put("FcsControlBootTime", FcsServer.getFcsServer().getLocalBootTime());
        } else if (this.operation.equals("FcsControlCommandHorizon")) {
            HashSet<MachineId> otherList = new HashSet<MachineId>();
            otherList.add(FcsServer.getFcsServer().getLocalMachineId());
            map.put("FcsControlCommandHorizon", otherList);
        }
        HashMap<MachineId, Set> servicesMap = new HashMap<MachineId, Set>();
        HashMap<MachineId, Date> bootTimesMap = new HashMap<MachineId, Date>();
        HashMap<MachineId, Long> handshakeTimesMap = new HashMap<MachineId, Long>();
        FcsServer fcsServer = FcsServer.getFcsServer();
        Set machineList = fcsServer.getMachineList();
        Iterator iterator = machineList.iterator();
        while (iterator.hasNext()) {
            MachineId tmpId = (MachineId)iterator.next();
            Set tmpServiceList = fcsServer.getRemoteServiceList(tmpId);
            Date tmpBootTime = fcsServer.getBootTime(tmpId);
            if (tmpServiceList == null || tmpServiceList.isEmpty() || tmpBootTime == null) continue;
            servicesMap.put(tmpId, tmpServiceList);
            bootTimesMap.put(tmpId, tmpBootTime);
            handshakeTimesMap.put(tmpId, new Long(FcsConnectionManager.timeSinceLastHandshake(tmpId)));
        }
        map.put("otherMachineServices", servicesMap);
        map.put("otherMachineBootTimes", bootTimesMap);
        map.put("otherMachineHandshakeTimes", handshakeTimesMap);
        return map;
    }

    private void handleInMap(Map inMap) {
        if (this.operation.equals("FcsControlCommandDataExchange")) {
            this.handleDataExchange(inMap);
        } else if (this.operation.equals("FcsControlCommandHorizon")) {
            this.handleHorizonSearch(inMap);
        }
        if (inMap.containsKey("otherMachineServices")) {
            Trace.trace(TRACE_MASKF, "We received info about other machines");
            Map servicesMap = (Map)inMap.get("otherMachineServices");
            Map bootTimesMap = (Map)inMap.get("otherMachineBootTimes");
            Map handshakeTimesMap = (Map)inMap.get("otherMachineHandshakeTimes");
            FcsServer fcsServer = FcsServer.getFcsServer();
            Iterator iterator = servicesMap.keySet().iterator();
            while (iterator.hasNext()) {
                MachineId tmpId = (MachineId)iterator.next();
                Set serviceList = (Set)servicesMap.get(tmpId);
                Date bootTime = (Date)bootTimesMap.get(tmpId);
                long handshakeTime = (Long)handshakeTimesMap.get(tmpId);
                if (!fcsServer.getRemoteServiceList(tmpId).isEmpty()) {
                    long ourHandshakeTime = FcsConnectionManager.timeSinceLastHandshake(tmpId);
                    if (handshakeTime < ourHandshakeTime) {
                        Trace.trace(TRACE_MASKF, "their info is newer");
                        fcsServer.addRemoteServiceList(tmpId, serviceList, bootTime);
                        FcsConnectionManager.didHandshake(tmpId, System.currentTimeMillis() - handshakeTime);
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "Our info is newer");
                    continue;
                }
                Trace.trace(TRACE_MASKF, "Don't know anything about: " + tmpId);
                Trace.trace(TRACE_MASKF, "not updating");
            }
        } else {
            Trace.trace(TRACE_MASKF, "We did not receive info about other machines");
        }
    }

    private void handleDataExchange(Map inMap) {
        Trace.trace(TRACE_MASKT, "<> FcsControlClient.handleDataExchange()");
        MachineId machineId = (MachineId)inMap.get("FcsControlMachineId");
        Set services = (Set)inMap.get("FcsControlServices");
        Date bootTime = (Date)inMap.get("FcsControlBootTime");
        if (machineId != null && services != null && bootTime != null) {
            InetAddress[] addrs = machineId.getNicAddresses();
            boolean ok = false;
            if (addrs != null) {
                for (int i = 0; i < addrs.length; ++i) {
                    if (addrs[i] == null || addrs[i].getHostAddress().startsWith("127.")) continue;
                    Trace.trace(TRACE_MASKF, "OK address: " + addrs[i].getHostAddress());
                    ok = true;
                    i = addrs.length;
                }
            }
            if (ok) {
                FcsServer.getFcsServer().addRemoteServiceList(machineId, services, bootTime);
                FcsConnectionManager.didHandshake(machineId);
            } else {
                Trace.trace(TRACE_MASKF, "Inbound MachineID did not have a valid address: " + machineId);
            }
        }
    }

    private void handleHorizonSearch(Map inMap) {
        Trace.trace(TRACE_MASKT, "<> FcsControlClient.handleHorizonSearch() [deprecated]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(Exception e) {
        Object object = badConnectionsLock;
        synchronized (object) {
            for (int j = 0; j < this.machineId.getNicAddresses().length; ++j) {
                if (this.machineId.getNicAddresses()[j] == null) continue;
                Integer i = (Integer)retryMap.get(this.machineId.getNicAddresses()[j]);
                if (i == null) {
                    Trace.trace(TRACE_MASKF, "creating retry entry for " + this.machineId.getName());
                    retryMap.put(this.machineId.getNicAddresses()[j], new Integer(1));
                    continue;
                }
                if (i == 3) {
                    Trace.trace(TRACE_MASKF, "creating blacklist entry for " + this.machineId.getName());
                    badConnections.put(this.machineId.getNicAddresses()[j], new Integer(1));
                    retryMap.remove(this.machineId.getNicAddresses()[j]);
                    continue;
                }
                Trace.trace(TRACE_MASKF, "updating retry entry for " + this.machineId.getName());
                retryMap.put(this.machineId.getNicAddresses()[j], new Integer(i + 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBlacklist() {
        Object object = badConnectionsLock;
        synchronized (object) {
            Integer i;
            InetAddress nextAddr;
            Iterator iterator = ((Map)((HashMap)badConnections).clone()).keySet().iterator();
            while (iterator.hasNext()) {
                nextAddr = (InetAddress)iterator.next();
                i = (Integer)badConnections.get(nextAddr);
                if (i == 12) {
                    Trace.trace(TRACE_MASKF, "removing blacklist entry for: " + nextAddr);
                    badConnections.remove(nextAddr);
                    continue;
                }
                Trace.trace(TRACE_MASKF, "updating blacklist entry for: " + nextAddr);
                badConnections.put(nextAddr, new Integer(i + 1));
            }
            iterator = ((Map)((HashMap)retryMap).clone()).keySet().iterator();
            while (iterator.hasNext()) {
                nextAddr = (InetAddress)iterator.next();
                i = (Integer)retryMap.get(nextAddr);
                if (i == 0) {
                    Trace.trace(TRACE_MASKF, "removing retry entry for: " + nextAddr);
                    retryMap.remove(nextAddr);
                    continue;
                }
                Trace.trace(TRACE_MASKF, "updating retry entry for: " + nextAddr);
                retryMap.put(nextAddr, new Integer(i - 1));
            }
        }
    }

    public String getRemoteChatletClass() {
        return "com.ibm.hwmca.fw.fcs.impl.stream.FcsControlService";
    }

    public void setChatletClientPortal(ChatletClientPortal portal) {
        Trace.trace(TRACE_MASKT, "<> setChatletClientPortal()");
        this.portal = portal;
    }

    public void asynchronousMessage(ChatletMessage message) {
        Trace.trace(TRACE_MASKT, "-> asynchronousMessage()");
        Trace.trace(TRACE_MASKT, "<- asynchronousMessage()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Trace.trace(TRACE_MASKT, "-> destroy()");
        Object object = openConnectionsLock;
        synchronized (object) {
            for (int i = 0; i < this.machineId.getNicAddresses().length; ++i) {
                if (this.machineId.getNicAddresses()[i] == null) continue;
                openConnections.remove(this.machineId.getNicAddresses()[i]);
            }
        }
        FcsControlClient.removeChatletClient(this.machineId);
        Trace.trace(TRACE_MASKT, "<- destroy()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeChatletClient(MachineId machine) {
        FcsControlClient chatlet = null;
        Object object = chatletLock;
        synchronized (object) {
            chatlet = (FcsControlClient)chatletClients.remove(machine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void machineChanged(MachineId machine, MachineId oldMachine) {
        Object object = chatletLock;
        synchronized (object) {
            if (chatletClients.containsKey(oldMachine)) {
                FcsControlClient chatletClient = (FcsControlClient)chatletClients.get(oldMachine);
                chatletClient.machineId = machine;
                chatletClients.remove(oldMachine);
                chatletClients.put(machine, chatletClient);
            }
        }
    }

    static {
        FcsServer.getFcsServer().addFcsEventListener(new FcsEventListener(){

            public void fcsStateChanged(FcsEvent event) {
                MachineId machine = event.getMachineId();
                Set services = event.getServices();
                int type = event.getEventType();
                int details = event.getEventDetails();
                if (type == 1 && details == 54) {
                    FcsControlClient.machineChanged(machine, event.getOldMachineId());
                } else if (type == 1 && details == 52) {
                    FcsControlClient.removeChatletClient(machine);
                }
            }
        });
    }
}

